/*
 *  kexbases\kernel32\Vista.c
 *
 *  Copyright (C) 2019, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "_kernel32_apilist.h"


// MAKE_EXPORT CreateEventExA_vista=CreateEventExA
HANDLE CreateEventExA_vista (
  LPSECURITY_ATTRIBUTES lpEventAttributes,
  LPCSTR lpName,
  DWORD   dwFlags,
  DWORD   dwDesiredAccess
)
{
#define bManualReset  (dwFlags&1)
#define bInitialState (dwFlags&2>>1)
  return CreateEvent (lpEventAttributes, bManualReset, bInitialState, lpName);
}
